try:
    import torch

    print(f"✅ PyTorch 导入成功，版本: {torch.__version__}")
    print(f"GPU 可用: {torch.cuda.is_available()}")

    # 简单张量操作，验证 PyTorch 能正常运行
    x = torch.tensor([1.0, 2.0])
    y = x + x
    print(f"PyTorch 计算测试: {x} + {x} = {y}")

except ImportError as e:
    print(f"❌ PyTorch 未安装或导入失败: {e}")

try:
    import transformers

    print(f"✅ Transformers 导入成功，版本: {transformers.__version__}")

    # 验证 AutoTokenizer 类存在（不下载模型）
    from transformers import AutoTokenizer

    print("AutoTokenizer 类可访问")

except ImportError as e:
    print(f"❌ Transformers 未安装或导入失败: {e}")

'''
Python 相关包的下载对应命令

pip config set global.index-url https://mirrors.tuna.tsinghua.edu.cn/pypi/web/simple

python -m pip install --upgrade pip

pip3 install torch torchvision

python -m pip install -U transformers

pip install modelscope

modelscope download --model Qwen/Qwen3-0.6B --local_dir ./dir

'''